﻿$(document).ready(function () {
    surveyProviders.$context = $("#surveyProviders");

    if (surveyProviders.$context.length > 0) {
        surveyProviders.bindEvents();
        surveyProviders.initializeDataTable();
    }
});

var surveyProviders = {
    $context: null,
    datatable: null,
    bindEvents: function () {
        $(".h-addSurveyProvider", surveyProviders.$context).on("click", function () {
            modalDialog.showWindow(a4.getAction("EditSampleProvider", "Surveys", "Settings"), 480, 600, { afterClose: function () { surveyProviders.refreshDataTable(); } });
        });
    },
    refreshDataTable: function () {
        surveyProviders.datatable.a4datatable("refresh");
    },
    initializeDataTable: function () {
        surveyProviders.datatable = $(".v-surveyProvidersTable", surveyProviders.$context).a4datatable({
            height: "full",
            stateKey:"SurveysSampleProviders",
            ajaxAction: a4.getAction("GetSampleProviders", "Surveys", "Settings"),
            columns: [
                { "Name": "Id", "Title": resources.Id, "Data": "Id", "Visible": true, "Class": "id", "Key": true },
                { "Name": "Name", "Title": resources.Name, "Data": "Name", "Class": "v-name" },
                { "Name": "CreationDate", "Title": resources.CreatedOn, "Data": "CreationDate" },
                { "Name": "CreatedBy", "Title": resources.CreatedBy, "Data": "CreatedBy" },
                { "Name": "ModificationDate", "Title": resources.ModifiedOn, "Data": "ModificationDate" },
                { "Name": "ModifiedBy", "Title": resources.ModifiedBy, "Data": "ModifiedBy" }
            ],
            localizableTexts: { "Search": resources.SearchSampleProviders },
            defaultSorting: "Name",
            toolBarItems: surveyProviders.getToolBarItems(),
            toolBarClick: function (event, data) {
                var rows = data.rows;
                var action = data.action;
                var ids = [];

                for (var i = 0; i < rows.length; i++) {
                    ids.push(rows[i].Id);
                }

                if (action == "delete") {
                    surveyProviders.deleteItems(ids);
                }
            },
            contextMenuItems: surveyProviders.getContextMenuItems(),
            contextMenuClick: function (event, data) {
                var row = data.row;
                var action = data.action;

                switch (action) {
                    case "properties": surveyProviders.showEditDialog(row.Id); break;
                    case "delete": surveyProviders.deleteItems(row.Id); break;
                }
            }
        });
    },
    getContextMenuItems: function () {
        var items = [];
        if (canModifySettings) {
            items.push({ "Action": "delete", "Label": resources.Delete });
            items.push({ "Action": "properties", "Label": resources.Properties });
        }
        return items;
    },
    getToolBarItems: function () {
        var items = [];
        if (canModifySettings) {
            items.push({ "Action": "delete", "Label": resources.Delete });
        }
        return items;
    },
    deleteItems: function (items) {
        var itemsCount = items.length;
        if (itemsCount === undefined) {
            itemsCount = 1;
        }

        modalDialog.showConfirmDialog(confirmDeleteSurveyProviderDefinitionResources, function () {
            a4.callServerMethod(a4.getAction("DeleteSampleProviders", "Surveys", "Settings"), { itemIds: items },
                function (result) {
                    surveyProviders.refreshDataTable();
                });
        }, 250, 500, true, { "count": itemsCount });
    },
    showEditDialog: function (id) {
        modalDialog.showWindow(a4.getAction("EditSampleProvider", "Surveys", "Settings", { id: id }), 570, 600, { afterClose: function () { surveyProviders.refreshDataTable(); } });
    }
}